/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.random;

import de.ganzer.core.random.Distribution;
import java.util.Random;

public class UniformIntegerDistribution
implements Distribution<Long> {
    private final long min;
    private final long max;

    public UniformIntegerDistribution() {
        this(0L, Integer.MAX_VALUE);
    }

    public UniformIntegerDistribution(long max) {
        this(0L, max);
    }

    public UniformIntegerDistribution(long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException("min,max");
        }
        this.min = min;
        this.max = max;
    }

    @Override
    public Long next(Random random) {
        return (long)(random.nextDouble() * (double)(this.max - this.min + 1L)) + this.min;
    }
}

