/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.random;

import de.ganzer.core.random.Distribution;
import java.util.Random;

public class WeibullDistribution
implements Distribution<Double> {
    private final double shape;
    private final double scale;

    public WeibullDistribution() {
        this(1.0, 1.0);
    }

    public WeibullDistribution(double shape) {
        this(shape, 1.0);
    }

    public WeibullDistribution(double shape, double scale) {
        if (shape <= 0.0) {
            throw new IllegalArgumentException("shape");
        }
        this.shape = shape;
        this.scale = scale;
    }

    @Override
    public Double next(Random random) {
        return this.scale * StrictMath.pow(-StrictMath.log(1.0 - random.nextDouble()), 1.0 / this.shape);
    }
}

