/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.util;

import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Function;

public final class FileNames {
    public static final String DEFAULT_COUNTED_FORMAT = "%1$s (%2$d)";
    public static final String DEFAULT_HINT_FORMAT = "%1$s - %2$s";
    public static final String DEFAULT_COUNTED_HINT_FORMAT = "%1$s - %2$s (%3$d)";
    private static final int FOR_LINUX = 0;
    private static final int FOR_MAC = 1;
    private static final int FOR_WINDOWS = 2;
    private static final int FOR_OTHERS = 2;
    private static final String[] INVALID_NAME_CHARS = new String[]{"/", "/:", "<>\\/\":|*?"};
    private static final String[] INVALID_MASKED_NAME_CHARS = new String[]{"/", ":/", "<>\\/\":|"};
    private static String countedFormat = "%1$s (%2$d)";
    private static String hintFormat = "%1$s - %2$s";
    private static String countedHintFormat = "%1$s - %2$s (%3$d)";
    private static Function<Character, String> charReplacement;

    public static String getCountedFormat() {
        return countedFormat;
    }

    public static void setCountedFormat(String countedFormat) {
        FileNames.countedFormat = countedFormat == null ? DEFAULT_COUNTED_FORMAT : countedFormat;
    }

    public static String getHintFormat() {
        return hintFormat;
    }

    public static void setHintFormat(String hintFormat) {
        FileNames.hintFormat = hintFormat == null ? DEFAULT_HINT_FORMAT : hintFormat;
    }

    public static String getCountedHintFormat() {
        return countedHintFormat;
    }

    public static void setCountedHintFormat(String countedHintFormat) {
        FileNames.countedHintFormat = countedHintFormat == null ? DEFAULT_COUNTED_HINT_FORMAT : countedHintFormat;
    }

    public static Function<Character, String> getCharReplacement() {
        return charReplacement;
    }

    public static void setCharReplacement(Function<Character, String> charReplacement) {
        FileNames.charReplacement = charReplacement;
    }

    public static boolean isValidName(String name) {
        return FileNames.isValidName(name, FileNames.getInvalidNameChars());
    }

    public static boolean isValidMaskedName(String name) {
        return FileNames.isValidName(name, FileNames.getInvalidMaskedNameChars());
    }

    public static String getValidName(String name) {
        return FileNames.getValidName(name, FileNames.getInvalidNameChars());
    }

    public static String getValidMaskedName(String name) {
        return FileNames.getValidName(name, FileNames.getInvalidMaskedNameChars());
    }

    public static String getUniqueName(String path, String hint) {
        Objects.requireNonNull(path, "FileNameTools::getUniqueName: path");
        Path result = FileNames.getUniqueName(Path.of(path, new String[0]), hint);
        return result == null ? null : result.toString();
    }

    public static Path getUniqueName(Path path, String hint) {
        int i;
        boolean hasHint;
        String newName;
        Path newPath;
        Objects.requireNonNull(path, "FileNameTools::getUniqueName: path");
        if (!path.toFile().exists()) {
            return path;
        }
        String dir = path.getParent().toString();
        String name = FileNames.getNameWithoutExtensions(path);
        Object ext = FileNames.getAllExtensions(path);
        if (!((String)ext).isEmpty()) {
            ext = "." + (String)ext;
        }
        if (!(newPath = Path.of(dir, (newName = (hasHint = hint != null && !hint.isEmpty()) ? String.format(hintFormat, name, hint) : String.format(countedFormat, name, 2)) + (String)ext)).toFile().exists()) {
            return newPath;
        }
        int n = i = hasHint ? 2 : 3;
        while (i < Integer.MAX_VALUE) {
            newName = hasHint ? String.format(countedHintFormat, name, hint, i) : String.format(countedFormat, name, i);
            newPath = Path.of(dir, newName + (String)ext);
            if (!newPath.toFile().exists()) {
                return newPath;
            }
            ++i;
        }
        return null;
    }

    public static String getNameWithoutLastExtension(String path) {
        Objects.requireNonNull(path, "FileNameTools::getNameWithoutLastExtension: path");
        return FileNames.getNameWithoutLastExtension(Path.of(path, new String[0]));
    }

    public static String getNameWithoutLastExtension(Path path) {
        Objects.requireNonNull(path, "FileNameTools::getNameWithoutLastExtension: path");
        String name = path.getFileName().toString();
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return name;
        }
        return name.substring(0, i);
    }

    public static String getNameWithoutExtensions(String path) {
        Objects.requireNonNull(path, "FileNameTools::getNameWithoutExtensions: path");
        return FileNames.getNameWithoutExtensions(Path.of(path, new String[0]));
    }

    public static String getNameWithoutExtensions(Path path) {
        Objects.requireNonNull(path, "FileNameTools::getNameWithoutExtensions: path");
        String name = path.getFileName().toString();
        int i = name.indexOf(46);
        if (i == -1) {
            return name;
        }
        return name.substring(0, i);
    }

    public static String getExtension(String path) {
        Objects.requireNonNull(path, "FileNameTools::getExtension: path");
        int i = path.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return path.substring(i + 1);
    }

    public static String getExtension(Path path) {
        Objects.requireNonNull(path, "FileNameTools::getExtension: path");
        return FileNames.getExtension(path.toString());
    }

    public static String getAllExtensions(String path) {
        Objects.requireNonNull(path, "FileNameTools::getAllExtensions: path");
        return FileNames.getAllExtensions(Path.of(path, new String[0]));
    }

    public static String getAllExtensions(Path path) {
        Objects.requireNonNull(path, "FileNameTools::getAllExtensions: path");
        String name = path.getFileName().toString();
        int i = name.indexOf(46);
        if (i == -1) {
            return "";
        }
        return name.substring(i + 1);
    }

    private static boolean isValidName(String name, String invalidChars) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (invalidChars.indexOf(c) < 0) continue;
            return false;
        }
        return true;
    }

    private static String getValidName(String name, String invalidChars) {
        Function<Character, String> replacement = charReplacement != null ? charReplacement : FileNames::defaultCharReplacement;
        StringBuilder newName = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (invalidChars.indexOf(c) < 0) {
                newName.append(c);
                continue;
            }
            newName.append(replacement.apply(Character.valueOf(c)));
        }
        return newName.toString();
    }

    private static String getInvalidNameChars() {
        return INVALID_NAME_CHARS[FileNames.getOSSelector()];
    }

    private static String getInvalidMaskedNameChars() {
        return INVALID_MASKED_NAME_CHARS[FileNames.getOSSelector()];
    }

    private static int getOSSelector() {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            return 2;
        }
        if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            return 0;
        }
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            return 1;
        }
        return 2;
    }

    private static String defaultCharReplacement(Character c) {
        return String.format("%%%02X", c.charValue());
    }
}

