/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.util;

import java.util.Properties;

public class Settings
extends Properties {
    public String read(String key, String defaultValue) {
        String value = this.getProperty(key);
        return value != null ? value : defaultValue;
    }

    public int read(String key, int defaultValue) {
        String value = this.getProperty(key);
        try {
            return value != null ? Integer.parseInt(value) : defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public long read(String key, long defaultValue) {
        String value = this.getProperty(key);
        try {
            return value != null ? Long.parseLong(value) : defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public float read(String key, float defaultValue) {
        String value = this.getProperty(key);
        try {
            return value != null ? Float.parseFloat(value) : defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public double read(String key, double defaultValue) {
        String value = this.getProperty(key);
        try {
            return value != null ? Double.parseDouble(value) : defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean read(String key, boolean defaultValue) {
        String value = this.getProperty(key);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    public <T extends Enum<T>> T read(String key, T defaultValue) {
        String value = this.getProperty(key);
        try {
            return value != null ? Enum.valueOf(defaultValue.getDeclaringClass(), value) : defaultValue;
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public void write(String key, String value) {
        this.setProperty(key, value);
    }

    public void write(String key, long value) {
        this.setProperty(key, Long.toString(value));
    }

    public void write(String key, double value) {
        this.setProperty(key, Double.toString(value));
    }

    public void write(String key, boolean value) {
        this.setProperty(key, Boolean.toString(value));
    }

    public <T extends Enum<T>> void write(String key, T value) {
        this.setProperty(key, value.name());
    }
}

