/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.util;

import de.ganzer.core.internals.CoreMessages;
import de.ganzer.core.util.DuplicateSettingException;
import de.ganzer.core.util.FileNames;
import de.ganzer.core.util.Settings;
import de.ganzer.core.util.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.WeakHashMap;

public class UserSettings
extends Settings {
    private static final WeakHashMap<String, UserSettings> knownSettings = new WeakHashMap();
    private final String appName;
    private final String appVersion;
    private final String fileName;
    private final boolean asXml;

    public UserSettings(String appName, String appVersion) {
        this(appName, appVersion, null, false);
    }

    public UserSettings(String appName, String appVersion, boolean asXml) {
        this(appName, appVersion, null, asXml);
    }

    public UserSettings(String appName, String appVersion, String fileName) {
        this(appName, appVersion, fileName, false);
    }

    public UserSettings(String appName, String appVersion, String fileName, boolean asXml) {
        if (Strings.isNullOrBlank(appName)) {
            throw new IllegalArgumentException("appName must not be null or empty.");
        }
        if (Strings.isNullOrBlank(appVersion)) {
            throw new IllegalArgumentException("appVersion must not be null or empty.");
        }
        if (fileName != null && (Strings.isNullOrBlank(fileName) || !FileNames.isValidName(fileName))) {
            throw new IllegalArgumentException("fileName is not a valid file name.");
        }
        this.asXml = asXml;
        this.appName = appName;
        this.appVersion = appVersion;
        this.fileName = fileName == null ? "settings" : fileName;
        String key = this.appName + this.appVersion + this.fileName;
        if (knownSettings.get(key) != null) {
            throw new DuplicateSettingException(this.fileName);
        }
        knownSettings.put(key, this);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void save() throws IOException {
        try (FileOutputStream out = new FileOutputStream(this.getSettingsStoragePath());){
            if (this.asXml) {
                this.storeToXML(out, String.format("Settings of %s %s", this.appName, this.appVersion));
            } else {
                this.store(out, String.format("Settings of %s %s", this.appName, this.appVersion));
            }
        }
        catch (Exception e) {
            throw new IOException(CoreMessages.get("error.cannotStoreSettings", this.getSettingsStoragePath()), e);
        }
    }

    public void load() throws IOException {
        try {
            if (!new File(this.getSettingsStoragePath()).exists()) {
                return;
            }
            try (FileInputStream in = new FileInputStream(this.getSettingsStoragePath());){
                if (this.asXml) {
                    this.loadFromXML(in);
                } else {
                    this.load(in);
                }
            }
        }
        catch (Exception e) {
            throw new IOException(CoreMessages.get("error.cannotLoadSettings", this.getSettingsStoragePath()), e);
        }
    }

    private String getSettingsStoragePath() {
        String home = System.getProperty("user.home");
        String osName = System.getProperty("os.name");
        String path = osName.startsWith("Windows") ? Path.of(home, "AppData", "Roaming", FileNames.getValidName(this.appName), FileNames.getValidName(this.appVersion)).toString() : Path.of(home, ".config", FileNames.getValidName(this.appName), FileNames.getValidName(this.appVersion)).toString();
        File file = new File(path);
        file.mkdirs();
        return Path.of(path, this.fileName).toString();
    }
}

