/*
 * Decompiled with CFR 0.152.
 */
package de.ganzer.core.validation;

import de.ganzer.core.internals.CoreMessages;
import de.ganzer.core.validation.Validator;
import de.ganzer.core.validation.ValidatorException;
import de.ganzer.core.validation.ValidatorExceptionRef;

public class CharCountValidator
extends Validator {
    private int maxLength;
    private int minLength;

    public CharCountValidator() {
    }

    public CharCountValidator(int options) {
        super(options);
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException("maxLength");
        }
        this.maxLength = maxLength;
        if (this.minLength > 0 && maxLength < this.minLength) {
            this.minLength = maxLength;
        }
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        if (minLength < 0) {
            throw new IllegalArgumentException("minLength");
        }
        this.minLength = minLength;
        if (this.maxLength > 0 && minLength > this.maxLength) {
            this.maxLength = minLength;
        }
    }

    @Override
    protected boolean doInputValidation(StringBuilder text, boolean autoFill) {
        if (!super.doInputValidation(text, autoFill)) {
            return false;
        }
        return this.maxLength == 0 || text.length() <= this.maxLength;
    }

    @Override
    protected boolean doValidate(String text, ValidatorExceptionRef er) {
        if (!super.doValidate(text, er)) {
            return false;
        }
        if (text.isEmpty()) {
            return true;
        }
        if (this.maxLength != 0 && text.length() > this.maxLength) {
            er.setException(new ValidatorException(String.format(this.getErrorMessage() != null ? this.getErrorMessage() : CoreMessages.get("inputExceedsMaxLength"), this.maxLength)));
        } else if (this.minLength != 0 && text.length() < this.minLength) {
            er.setException(new ValidatorException(String.format(this.getErrorMessage() != null ? this.getErrorMessage() : CoreMessages.get("inputBelowMinLength"), this.minLength)));
        }
        return er.getException() == null;
    }
}

